; Swordfish Structured BASIC Compiler for PICmicros.
; Version 1.1.5.5 Copyright Mecanique 2010
;
; \\psf\Google Drive\Projects\Logic Ruler\18F43K20 Digirule Source.BAS 10/10/2015
;
 PROCESSOR PIC18F43K20
 RADIX DEC
 ERRORLEVEL 2
 EXPAND ON
; SPECIAL FUNCTION REGISTERS...
SSPMSK           EQU 0X0F77
SLRCON           EQU 0X0F78
CM2CON1          EQU 0X0F79
CM2CON0          EQU 0X0F7A
CM1CON0          EQU 0X0F7B
WPUB             EQU 0X0F7C
IOCB             EQU 0X0F7D
ANSEL            EQU 0X0F7E
ANSELH           EQU 0X0F7F
LATA             EQU 0X0F89
LATB             EQU 0X0F8A
LATC             EQU 0X0F8B
LATD             EQU 0X0F8C
LATE             EQU 0X0F8D
DDRA             EQU 0X0F92
TRISA            EQU 0X0F92
DDRB             EQU 0X0F93
TRISB            EQU 0X0F93
DDRC             EQU 0X0F94
TRISC            EQU 0X0F94
DDRD             EQU 0X0F95
TRISD            EQU 0X0F95
DDRE             EQU 0X0F96
TRISE            EQU 0X0F96
OSCTUNE          EQU 0X0F9B
PIE1             EQU 0X0F9D
PIR1             EQU 0X0F9E
IPR1             EQU 0X0F9F
PIE2             EQU 0X0FA0
PIR2             EQU 0X0FA1
IPR2             EQU 0X0FA2
EECON1           EQU 0X0FA6
EECON2           EQU 0X0FA7
EEDATA           EQU 0X0FA8
EEADR            EQU 0X0FA9
RCSTA            EQU 0X0FAB
TXSTA            EQU 0X0FAC
TXREG            EQU 0X0FAD
RCREG            EQU 0X0FAE
SPBRG            EQU 0X0FAF
SPBRGH           EQU 0X0FB0
T3CON            EQU 0X0FB1
TMR3L            EQU 0X0FB2
TMR3LH           EQU 0X0FB3
TMR3H            EQU 0X0FB3
CVRCON2          EQU 0X0FB4
CVRCON           EQU 0X0FB5
ECCP1AS          EQU 0X0FB6
PWM1CON          EQU 0X0FB7
BAUDCON          EQU 0X0FB8
BAUDCTL          EQU 0X0FB8
PSTRCON          EQU 0X0FB9
CCP2CON          EQU 0X0FBA
CCPR2            EQU 0X0FBB
CCPR2L           EQU 0X0FBB
CCPR2LH          EQU 0X0FBC
CCPR2H           EQU 0X0FBC
CCP1CON          EQU 0X0FBD
CCPR1            EQU 0X0FBE
CCPR1L           EQU 0X0FBE
CCPR1LH          EQU 0X0FBF
CCPR1H           EQU 0X0FBF
ADCON2           EQU 0X0FC0
ADCON1           EQU 0X0FC1
ADCON0           EQU 0X0FC2
ADRES            EQU 0X0FC3
ADRESL           EQU 0X0FC3
ADRESLH          EQU 0X0FC4
ADRESH           EQU 0X0FC4
SSPCON2          EQU 0X0FC5
SSPCON1          EQU 0X0FC6
SSPSTAT          EQU 0X0FC7
SSPADD           EQU 0X0FC8
SSPBUF           EQU 0X0FC9
T2CON            EQU 0X0FCA
PR2              EQU 0X0FCB
TMR2             EQU 0X0FCC
T1CON            EQU 0X0FCD
TMR1L            EQU 0X0FCE
TMR1LH           EQU 0X0FCF
TMR1H            EQU 0X0FCF
RCON             EQU 0X0FD0
WDTCON           EQU 0X0FD1
HLVDCON          EQU 0X0FD2
LVDCON           EQU 0X0FD2
OSCCON           EQU 0X0FD3
T0CON            EQU 0X0FD5
TMR0L            EQU 0X0FD6
TMR0LH           EQU 0X0FD7
TMR0H            EQU 0X0FD7
STATUS           EQU 0X0FD8
FSR2L            EQU 0X0FD9
FSR2LH           EQU 0X0FDA
FSR2H            EQU 0X0FDA
PLUSW2           EQU 0X0FDB
PREINC2          EQU 0X0FDC
POSTDEC2         EQU 0X0FDD
POSTINC2         EQU 0X0FDE
INDF2            EQU 0X0FDF
BSR              EQU 0X0FE0
FSR1L            EQU 0X0FE1
FSR1LH           EQU 0X0FE2
FSR1H            EQU 0X0FE2
PLUSW1           EQU 0X0FE3
PREINC1          EQU 0X0FE4
POSTDEC1         EQU 0X0FE5
POSTINC1         EQU 0X0FE6
INDF1            EQU 0X0FE7
WREG             EQU 0X0FE8
FSR0L            EQU 0X0FE9
FSR0LH           EQU 0X0FEA
FSR0H            EQU 0X0FEA
PLUSW0           EQU 0X0FEB
PREINC0          EQU 0X0FEC
POSTDEC0         EQU 0X0FED
POSTINC0         EQU 0X0FEE
INDF0            EQU 0X0FEF
INTCON3          EQU 0X0FF0
INTCON2          EQU 0X0FF1
INTCON           EQU 0X0FF2
PROD             EQU 0X0FF3
PRODL            EQU 0X0FF3
PRODLH           EQU 0X0FF4
PRODH            EQU 0X0FF4
TABLAT           EQU 0X0FF5
TBLPTR           EQU 0X0FF6
TBLPTRL          EQU 0X0FF6
TBLPTRLH         EQU 0X0FF7
TBLPTRH          EQU 0X0FF7
TBLPTRU          EQU 0X0FF8
PC               EQU 0X0FF9
PCL              EQU 0X0FF9
PCLATH           EQU 0X0FFA
PCLATU           EQU 0X0FFB
STKPTR           EQU 0X0FFC
TOS              EQU 0X0FFD
TOSL             EQU 0X0FFD
TOSLH            EQU 0X0FFE
TOSH             EQU 0X0FFE
TOSU             EQU 0X0FFF
; SYSTEM PORTS...
PORTE            EQU 0X0F84
PORTD            EQU 0X0F83
PORTC            EQU 0X0F82
PORTB            EQU 0X0F81
PORTA            EQU 0X0F80
; SSPMSK
MSK0 = 0
MSK1 = 1
MSK2 = 2
MSK3 = 3
MSK4 = 4
MSK5 = 5
MSK6 = 6
MSK7 = 7
; SLRCON
SLRA = 0
SLRB = 1
SLRC = 2
SLRD = 3
SLRE = 4
; CM2CON1
C2RSEL = 4
C1RSEL = 5
MC2OUT = 6
MC1OUT = 7
; CM2CON0
C2R = 2
C2SP = 3
C2POL = 4
C2OE = 5
C2OUT_CM2CON0 = 6
C2ON = 7
C2CH0 = 0
C2CH1 = 1
; CM1CON0
C1R = 2
C1SP = 3
C1POL = 4
C1OE = 5
C1OUT_CM1CON0 = 6
C1ON = 7
C1CH0 = 0
C1CH1 = 1
; WPUB
WPUB0 = 0
WPUB1 = 1
WPUB2 = 2
WPUB3 = 3
WPUB4 = 4
WPUB5 = 5
WPUB6 = 6
WPUB7 = 7
; IOCB
IOCB4 = 4
IOCB5 = 5
IOCB6 = 6
IOCB7 = 7
; ANSEL
ANS0 = 0
ANS1 = 1
ANS2 = 2
ANS3 = 3
ANS4 = 4
ANS5 = 5
ANS6 = 6
ANS7 = 7
; ANSELH
ANS8 = 0
ANS9 = 1
ANS10 = 2
ANS11 = 3
ANS12 = 4
; PORTA
RA0 = 0
RA1 = 1
RA2 = 2
RA3 = 3
RA4 = 4
RA5 = 5
RA6 = 6
RA7 = 7
AN0 = 0
AN1 = 1
AN2 = 2
AN3 = 3
AN4 = 5
C12IN0M = 0
C12IN1M = 1
C2INP = 2
C1INP = 3
C1OUT_PORTA = 4
C2OUT_PORTA = 5
C12IN0N = 0
C12IN1N = 1
VREFM = 2
VREFP = 3
T0CKI = 4
SS = 5
VREFN = 2
NOT_SS = 5
CVREF = 2
LVDIN = 5
HLVDIN = 5
; PORTB
RB0 = 0
RB1 = 1
RB2 = 2
RB3 = 3
RB4 = 4
RB5 = 5
RB6 = 6
RB7 = 7
INT0 = 0
INT1 = 1
INT2 = 2
CCP2_PORTB = 3
KBI0 = 4
KBI1 = 5
KBI2 = 6
KBI3 = 7
AN12 = 0
AN10 = 1
AN8 = 2
AN9 = 3
AN11 = 4
PGM = 5
PGC = 6
PGD = 7
FLT0 = 0
C12IN3M = 1
C12IN2M = 3
C12IN3N = 1
C12IN2N = 3
; PORTC
RC0 = 0
RC1 = 1
RC2 = 2
RC3 = 3
RC4 = 4
RC5 = 5
RC6 = 6
RC7 = 7
T1OSO = 0
T1OSI = 1
CCP1 = 2
SCK = 3
SDI = 4
SDO = 5
TX = 6
RX = 7
T13CKI = 0
CCP2_PORTC = 1
P1A = 2
SCL = 3
SDA = 4
CK = 6
; DT = 7
T1CKI = 0
T3CKI = 0
; PORTD
RD0 = 0
RD1 = 1
RD2 = 2
RD3 = 3
RD4 = 4
RD5 = 5
RD6 = 6
RD7 = 7
PSP0 = 0
PSP1 = 1
PSP2 = 2
PSP3 = 3
PSP4 = 4
PSP5 = 5
PSP6 = 6
PSP7 = 7
P1B = 5
P1C = 6
P1D = 7
; PORTE
RE0 = 0
RE1 = 1
RE2 = 2
RE3 = 3
RD = 0
WR = 1
CS = 2
MCLR = 3
NOT_RD = 0
NOT_WR = 1
NOT_CS = 2
NOT_MCLR = 3
VPP = 3
AN5 = 0
AN6 = 1
AN7 = 2
; LATA
LATA0 = 0
LATA1 = 1
LATA2 = 2
LATA3 = 3
LATA4 = 4
LATA5 = 5
LATA6 = 6
LATA7 = 7
; LATB
LATB0 = 0
LATB1 = 1
LATB2 = 2
LATB3 = 3
LATB4 = 4
LATB5 = 5
LATB6 = 6
LATB7 = 7
; LATC
LATC0 = 0
LATC1 = 1
LATC2 = 2
LATC3 = 3
LATC4 = 4
LATC5 = 5
LATC6 = 6
LATC7 = 7
; LATD
LATD0 = 0
LATD1 = 1
LATD2 = 2
LATD3 = 3
LATD4 = 4
LATD5 = 5
LATD6 = 6
LATD7 = 7
; LATE
LATE0 = 0
LATE1 = 1
LATE2 = 2
; DDRA
TRISA0 = 0
TRISA1 = 1
TRISA2 = 2
TRISA3 = 3
TRISA4 = 4
TRISA5 = 5
TRISA6 = 6
TRISA7 = 7
RA0 = 0
RA1 = 1
RA2 = 2
RA3 = 3
RA4 = 4
RA5 = 5
RA6 = 6
RA7 = 7
; TRISA
TRISA0 = 0
TRISA1 = 1
TRISA2 = 2
TRISA3 = 3
TRISA4 = 4
TRISA5 = 5
TRISA6 = 6
TRISA7 = 7
RA0 = 0
RA1 = 1
RA2 = 2
RA3 = 3
RA4 = 4
RA5 = 5
RA6 = 6
RA7 = 7
; DDRB
TRISB0 = 0
TRISB1 = 1
TRISB2 = 2
TRISB3 = 3
TRISB4 = 4
TRISB5 = 5
TRISB6 = 6
TRISB7 = 7
RB0 = 0
RB1 = 1
RB2 = 2
RB3 = 3
RB4 = 4
RB5 = 5
RB6 = 6
RB7 = 7
; TRISB
TRISB0 = 0
TRISB1 = 1
TRISB2 = 2
TRISB3 = 3
TRISB4 = 4
TRISB5 = 5
TRISB6 = 6
TRISB7 = 7
RB0 = 0
RB1 = 1
RB2 = 2
RB3 = 3
RB4 = 4
RB5 = 5
RB6 = 6
RB7 = 7
; DDRC
TRISC0 = 0
TRISC1 = 1
TRISC2 = 2
TRISC3 = 3
TRISC4 = 4
TRISC5 = 5
TRISC6 = 6
TRISC7 = 7
RC0 = 0
RC1 = 1
RC2 = 2
RC3 = 3
RC4 = 4
RC5 = 5
RC6 = 6
RC7 = 7
; TRISC
TRISC0 = 0
TRISC1 = 1
TRISC2 = 2
TRISC3 = 3
TRISC4 = 4
TRISC5 = 5
TRISC6 = 6
TRISC7 = 7
RC0 = 0
RC1 = 1
RC2 = 2
RC3 = 3
RC4 = 4
RC5 = 5
RC6 = 6
RC7 = 7
; DDRD
TRISD0 = 0
TRISD1 = 1
TRISD2 = 2
TRISD3 = 3
TRISD4 = 4
TRISD5 = 5
TRISD6 = 6
TRISD7 = 7
RD0 = 0
RD1 = 1
RD2 = 2
RD3 = 3
RD4 = 4
RD5 = 5
RD6 = 6
RD7 = 7
; TRISD
TRISD0 = 0
TRISD1 = 1
TRISD2 = 2
TRISD3 = 3
TRISD4 = 4
TRISD5 = 5
TRISD6 = 6
TRISD7 = 7
RD0 = 0
RD1 = 1
RD2 = 2
RD3 = 3
RD4 = 4
RD5 = 5
RD6 = 6
RD7 = 7
; DDRE
TRISE0 = 0
TRISE1 = 1
TRISE2 = 2
PSPMODE = 4
IBOV = 5
OBF = 6
IBF = 7
RE0 = 0
RE1 = 1
RE2 = 2
; TRISE
TRISE0 = 0
TRISE1 = 1
TRISE2 = 2
PSPMODE = 4
IBOV = 5
OBF = 6
IBF = 7
RE0 = 0
RE1 = 1
RE2 = 2
; OSCTUNE
PLLEN = 6
INTSRC = 7
TUN0 = 0
TUN1 = 1
TUN2 = 2
TUN3 = 3
TUN4 = 4
TUN5 = 5
; PIE1
TMR1IE = 0
TMR2IE = 1
CCP1IE = 2
SSPIE = 3
TXIE = 4
RCIE = 5
ADIE = 6
PSPIE = 7
; PIR1
TMR1IF = 0
TMR2IF = 1
CCP1IF = 2
SSPIF = 3
TXIF = 4
RCIF = 5
ADIF = 6
PSPIF = 7
; IPR1
TMR1IP = 0
TMR2IP = 1
CCP1IP = 2
SSPIP = 3
TXIP = 4
RCIP = 5
ADIP = 6
PSPIP = 7
; PIE2
CCP2IE = 0
TMR3IE = 1
HLVDIE = 2
BCLIE = 3
EEIE = 4
C2IE = 5
C1IE = 6
OSCFIE = 7
LVDIE = 2
; PIR2
CCP2IF = 0
TMR3IF = 1
HLVDIF = 2
BCLIF = 3
EEIF = 4
C2IF = 5
C1IF = 6
OSCFIF = 7
LVDIF = 2
; IPR2
CCP2IP = 0
TMR3IP = 1
HLVDIP = 2
BCLIP = 3
EEIP = 4
C2IP = 5
C1IP = 6
OSCFIP = 7
LVDIP = 2
; EECON1
RD = 0
WR = 1
WREN = 2
WRERR = 3
FREE = 4
CFGS = 6
EEPGD = 7
; EEADR
EEADR0 = 0
EEADR1 = 1
EEADR2 = 2
EEADR3 = 3
EEADR4 = 4
EEADR5 = 5
EEADR6 = 6
EEADR7 = 7
; RCSTA
RX9D = 0
OERR = 1
FERR = 2
ADDEN = 3
CREN = 4
SREN = 5
RX9 = 6
SPEN = 7
ADEN = 3
; TXSTA
TX9D = 0
TRMT = 1
BRGH = 2
SENDB = 3
SYNC = 4
TXEN = 5
TX9 = 6
CSRC = 7
; T3CON
TMR3ON = 0
TMR3CS = 1
NOT_T3SYNC = 2
T3CCP1 = 3
T3CCP2 = 6
RD16 = 7
T3SYNC = 2
T3CKPS0 = 4
T3CKPS1 = 5
; CVRCON2
FVRST = 6
FVREN = 7
; CVRCON
CVRSS = 4
CVRR = 5
CVROE = 6
CVREN = 7
CVR0 = 0
CVR1 = 1
CVR2 = 2
CVR3 = 3
; ECCP1AS
ECCPASE = 7
PSSBD0 = 0
PSSBD1 = 1
PSSAC0 = 2
PSSAC1 = 3
ECCPAS0 = 4
ECCPAS1 = 5
ECCPAS2 = 6
; PWM1CON
PRSEN = 7
PDC0 = 0
PDC1 = 1
PDC2 = 2
PDC3 = 3
PDC4 = 4
PDC5 = 5
PDC6 = 6
; BAUDCON
ABDEN = 0
WUE = 1
BRG16 = 3
CKTXP = 4
DTRXP = 5
RCIDL = 6
ABDOVF = 7
SCKP = 4
; BAUDCTL
ABDEN = 0
WUE = 1
BRG16 = 3
CKTXP = 4
DTRXP = 5
RCIDL = 6
ABDOVF = 7
SCKP = 4
; PSTRCON
STRA = 0
STRB = 1
STRC = 2
STRD = 3
STRSYNC = 4
; CCP2CON
CCP2M0 = 0
CCP2M1 = 1
CCP2M2 = 2
CCP2M3 = 3
DC2B0 = 4
DC2B1 = 5
; CCP1CON
CCP1M0 = 0
CCP1M1 = 1
CCP1M2 = 2
CCP1M3 = 3
DC1B0 = 4
DC1B1 = 5
P1M0 = 6
P1M1 = 7
; ADCON2
ADFM = 7
ADCS0 = 0
ADCS1 = 1
ADCS2 = 2
ACQT0 = 3
ACQT1 = 4
ACQT2 = 5
; ADCON1
VCFG0 = 4
VCFG1 = 5
; ADCON0
ADON = 0
GO_NOT_DONE = 1
DONE = 1
CHS0 = 2
CHS1 = 3
CHS2 = 4
CHS3 = 5
NOT_DONE = 1
GO_DONE = 1
GO = 1
; SSPCON2
SEN = 0
RSEN = 1
PEN = 2
RCEN = 3
ACKEN = 4
ACKDT = 5
ACKSTAT = 6
GCEN = 7
; SSPCON1
CKP = 4
SSPEN = 5
SSPOV = 6
WCOL = 7
SSPM0 = 0
SSPM1 = 1
SSPM2 = 2
SSPM3 = 3
; SSPSTAT
BF = 0
UA = 1
R_NOT_W = 2
S = 3
P = 4
D_NOT_A = 5
CKE = 6
SMP = 7
R = 2
D = 5
NOT_W = 2
NOT_A = 5
R_W = 2
D_A = 5
NOT_WRITE = 2
NOT_ADDRESS = 5
START = 3
STOP = 4
; T2CON
TMR2ON = 2
T2CKPS0 = 0
T2CKPS1 = 1
T2OUTPS0 = 3
T2OUTPS1 = 4
T2OUTPS2 = 5
T2OUTPS3 = 6
; T1CON
TMR1ON = 0
TMR1CS = 1
NOT_T1SYNC = 2
T1OSCEN = 3
T1RUN = 6
RD16 = 7
T1SYNC = 2
T1CKPS0 = 4
T1CKPS1 = 5
; RCON
NOT_BOR = 0
NOT_POR = 1
NOT_PD = 2
NOT_TO = 3
NOT_RI = 4
SBOREN = 6
IPEN = 7
BOR = 0
POR = 1
PD = 2
TO = 3
RI = 4
; WDTCON
SWDTEN = 0
SWDTE = 0
; HLVDCON
HLVDEN = 4
IRVST = 5
VDIRMAG = 7
HLVDL0 = 0
HLVDL1 = 1
HLVDL2 = 2
HLVDL3 = 3
LVDL0 = 0
LVDL1 = 1
LVDL2 = 2
LVDL3 = 3
LVDEN = 4
IVRST = 5
LVV0 = 0
LVV1 = 1
LVV2 = 2
LVV3 = 3
BGST = 5
; LVDCON
HLVDEN = 4
IRVST = 5
VDIRMAG = 7
HLVDL0 = 0
HLVDL1 = 1
HLVDL2 = 2
HLVDL3 = 3
LVDL0 = 0
LVDL1 = 1
LVDL2 = 2
LVDL3 = 3
LVDEN = 4
IVRST = 5
LVV0 = 0
LVV1 = 1
LVV2 = 2
LVV3 = 3
BGST = 5
; OSCCON
IOFS = 2
OSTS = 3
IDLEN = 7
SCS0 = 0
SCS1 = 1
IRCF0 = 4
IRCF1 = 5
IRCF2 = 6
; T0CON
PSA = 3
T0SE = 4
T0CS = 5
T08BIT = 6
TMR0ON = 7
T0PS0 = 0
T0PS1 = 1
T0PS2 = 2
; STATUS
C = 0
DC = 1
Z = 2
OV = 3
N = 4
; INTCON3
INT1IF = 0
INT2IF = 1
INT1IE = 3
INT2IE = 4
INT1IP = 6
INT2IP = 7
INT1F = 0
INT2F = 1
INT1E = 3
INT2E = 4
INT1P = 6
INT2P = 7
; INTCON2
RBIP = 0
TMR0IP = 2
INTEDG2 = 4
INTEDG1 = 5
INTEDG0 = 6
NOT_RBPU = 7
RBPU = 7
; INTCON
RBIF = 0
INT0IF = 1
TMR0IF = 2
RBIE = 3
INT0IE = 4
TMR0IE = 5
PEIE_GIEL = 6
GIE_GIEH = 7
INT0F = 1
T0IF = 2
INT0E = 4
T0IE = 5
PEIE = 6
GIE = 7
GIEL = 6
GIEH = 7
; STKPTR
STKUNF = 6
STKFUL = 7
SP0 = 0
SP1 = 1
SP2 = 2
SP3 = 3
SP4 = 4
STKOVF = 7
 #DEFINE W 0
 #DEFINE F 1
 #DEFINE A 0
 #DEFINE _CLOCK 8000000
 #DEFINE CLRW CLRF 4072,0
 #DEFINE NEGW NEGF 4072,0
 #DEFINE SKPC BTFSS 4056,0,0
 #DEFINE SKPNC BTFSC 4056,0,0
 #DEFINE CLRC BCF 4056,0,0
 #DEFINE SETC BSF 4056,0,0
 #DEFINE SKPZ BTFSS 4056,2,0
 #DEFINE SKPNZ BTFSC 4056,2,0
 #DEFINE CLRZ BCF 4056,2,0
 #DEFINE SETZ BSF 4056,2,0
SB_SV0 EQU 0
SB_SV0H EQU 1
SB_SV0HH EQU 2
SB_SV0HHH EQU 3
SB_SV1 EQU 4
SB_SV1H EQU 5
SB_SV2 EQU 6
SB_SV2H EQU 7
SB_SV2HH EQU 8
SB_SV2HHH EQU 9
SB_SV3 EQU 10
SB_SV3H EQU 11
SB_SV3HH EQU 12
SB_SV3HHH EQU 13
SB_SV4 EQU 14
SB_SV4H EQU 15
SB_SV5 EQU 16
SB_SV5H EQU 17
SB_SV5HH EQU 18
SB_SV5HHH EQU 19
SB_SV6 EQU 20
SB_SV6H EQU 21
SB_SV6HH EQU 22
SB_SV6HHH EQU 23
SB_SV7 EQU 24
A0 EQU 4073
A0H EQU 4074
A1 EQU 4065
A1H EQU 4066
A2 EQU 4057
A2H EQU 4058
TBPTR EQU 4086
TBPTRH EQU 4087
PROD EQU 4083
PRODH EQU 4084
F0_U08 EQU 25
M0_U01 EQU 26
M1_U01 EQU 27
M2_U08 EQU 28
M3_U08 EQU 29
M4_U01 EQU 30
M4_U08 EQU 30
        ORG 0X00
        GOTO SBCDSTD
        ORG 0X08
SBCDSTD
        BRA MAIN
PROC_DOLOGICGATES_0
?I000000_F000_000072_P000001 ; L#MK IF LOGICSELECT = 1 AND LOGICSELECTPRESSED = FALSE THEN
        BTFSS PORTB,3,0
        BRA FALSE_0
        BTFSC M0_U01,2,0
        BRA FALSE_0
?I000001_F000_000073_P000001 ; L#MK LOGICSELECTPRESSED = TRUE
        BSF M0_U01,2,0
?I000002_F000_000074_P000001 ; L#MK INC(WHICHLOGICGATE)
        INCF M2_U08,1,0
?I000003_F000_000075_P000001 ; L#MK LOGICINPUTALED = 0
        BCF LATA,2,0
?I000004_F000_000076_P000001 ; L#MK LOGICINPUTBLED = 0
        BCF LATA,3,0
?I000005_F000_000077_P000001 ; L#MK IF WHICHLOGICGATE > 6 THEN
        MOVLW 6
        CPFSGT M2_U08
        BRA ENDIF_1
?I000006_F000_000078_P000001 ; L#MK WHICHLOGICGATE = 0
        CLRF M2_U08,0
ENDIF_1
        BRA ENDIF_0
FALSE_0
?I000007_F000_000080_P000001 ; L#MK ELSEIF LOGICSELECT = 0 THEN
        BTFSS PORTB,3,0
?I000008_F000_000081_P000001 ; L#MK LOGICSELECTPRESSED = FALSE
        BCF M0_U01,2,0
ENDIF_0
?I000009_F000_000084_P000001 ; L#MK IF LOGICINPUTA = 1 AND LOGICINPUTAPRESSED = FALSE THEN
        BTFSS PORTB,1,0
        BRA FALSE_1
        BTFSC M0_U01,0,0
        BRA FALSE_1
?I000010_F000_000085_P000001 ; L#MK LOGICINPUTAPRESSED = TRUE
        BSF M0_U01,0,0
?I000011_F000_000086_P000001 ; L#MK IF LOGICINPUTALED = 0 THEN
        BTFSC PORTA,2,0
        BRA FALSE_2
?I000012_F000_000087_P000001 ; L#MK LOGICINPUTALED = 1
        BSF LATA,2,0
        BRA ENDIF_3
FALSE_2
?I000013_F000_000089_P000001 ; L#MK LOGICINPUTALED = 0
        BCF LATA,2,0
ENDIF_3
        BRA ENDIF_2
FALSE_1
?I000014_F000_000091_P000001 ; L#MK ELSEIF LOGICINPUTA = 0 THEN
        BTFSS PORTB,1,0
?I000015_F000_000092_P000001 ; L#MK LOGICINPUTAPRESSED = FALSE
        BCF M0_U01,0,0
ENDIF_2
?I000016_F000_000095_P000001 ; L#MK IF LOGICINPUTB = 1 AND LOGICINPUTBPRESSED = FALSE AND WHICHL...
        BTFSS PORTB,2,0
        BRA FALSE_3
        BTFSC M0_U01,1,0
        BRA FALSE_3
        MOVF M2_U08,1,0
        BZ FALSE_3
?I000017_F000_000096_P000001 ; L#MK LOGICINPUTBPRESSED = TRUE
        BSF M0_U01,1,0
?I000018_F000_000097_P000001 ; L#MK IF LOGICINPUTBLED = 0 THEN
        BTFSC PORTA,3,0
        BRA FALSE_4
?I000019_F000_000098_P000001 ; L#MK LOGICINPUTBLED = 1
        BSF LATA,3,0
        BRA ENDIF_5
FALSE_4
?I000020_F000_000100_P000001 ; L#MK LOGICINPUTBLED = 0
        BCF LATA,3,0
ENDIF_5
        BRA ENDIF_4
FALSE_3
?I000021_F000_000102_P000001 ; L#MK ELSEIF LOGICINPUTB = 0 THEN
        BTFSS PORTB,2,0
?I000022_F000_000103_P000001 ; L#MK LOGICINPUTBPRESSED = FALSE
        BCF M0_U01,1,0
ENDIF_4
?I000023_F000_000106_P000001 ; L#MK SELECT WHICHLOGICGATE
?I000024_F000_000107_P000001 ; L#MK CASE 0
        TSTFSZ M2_U08,0
        BRA FALSE_5
?I000025_F000_000108_P000001 ; L#MK IF LOGICINPUTALED = 0 THEN
        BTFSC PORTA,2,0
        BRA FALSE_6
?I000026_F000_000109_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
        BRA ENDIF_7
FALSE_6
?I000027_F000_000111_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
ENDIF_7
?I000028_F000_000113_P000001 ; L#MK NOTGATELED = 1
        BSF LATA,4,0
?I000029_F000_000114_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000030_F000_000115_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000031_F000_000116_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000032_F000_000117_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000033_F000_000118_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000034_F000_000119_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_5
?I000035_F000_000120_P000001 ; L#MK CASE 1
        DECFSZ M2_U08,0,0
        BRA FALSE_7
?I000036_F000_000121_P000001 ; L#MK IF LOGICINPUTALED = 1 OR LOGICINPUTBLED = 1 THEN
        BTFSC PORTA,2,0
        BRA TRUE_15
        BTFSS PORTA,3,0
        BRA FALSE_8
TRUE_15
?I000037_F000_000122_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
        BRA ENDIF_8
FALSE_8
?I000038_F000_000124_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
ENDIF_8
?I000039_F000_000126_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000040_F000_000127_P000001 ; L#MK ORGATELED = 1
        BSF LATA,5,0
?I000041_F000_000128_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000042_F000_000129_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000043_F000_000130_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000044_F000_000131_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000045_F000_000132_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_7
?I000046_F000_000133_P000001 ; L#MK CASE 2
        MOVLW 2
        CPFSEQ M2_U08
        BRA FALSE_9
?I000047_F000_000134_P000001 ; L#MK IF LOGICINPUTALED = 1 AND LOGICINPUTBLED = 1 THEN
        BTFSS PORTA,2,0
        BRA FALSE_10
        BTFSS PORTA,3,0
        BRA FALSE_10
?I000048_F000_000135_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
        BRA ENDIF_9
FALSE_10
?I000049_F000_000137_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
ENDIF_9
?I000050_F000_000139_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000051_F000_000140_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000052_F000_000141_P000001 ; L#MK ANDGATELED = 1
        BSF LATA,6,0
?I000053_F000_000142_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000054_F000_000143_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000055_F000_000144_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000056_F000_000145_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_9
?I000057_F000_000146_P000001 ; L#MK CASE 3
        MOVLW 3
        CPFSEQ M2_U08
        BRA FALSE_11
?I000058_F000_000147_P000001 ; L#MK IF (LOGICINPUTALED = 0 AND LOGICINPUTBLED = 1) OR (LOGICINPU...
        BTFSC PORTA,2,0
        BRA LABEL_15
        BTFSC PORTA,3,0
        BRA TRUE_21
LABEL_15
        BTFSS PORTA,2,0
        BRA FALSE_12
        BTFSC PORTA,3,0
        BRA FALSE_12
TRUE_21
?I000059_F000_000148_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
        BRA ENDIF_10
FALSE_12
?I000060_F000_000150_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
ENDIF_10
?I000061_F000_000152_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000062_F000_000153_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000063_F000_000154_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000064_F000_000155_P000001 ; L#MK XORGATELED = 1
        BSF LATA,7,0
?I000065_F000_000156_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000066_F000_000157_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000067_F000_000158_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_11
?I000068_F000_000159_P000001 ; L#MK CASE 4
        MOVLW 4
        CPFSEQ M2_U08
        BRA FALSE_13
?I000069_F000_000160_P000001 ; L#MK IF LOGICINPUTALED = 1 OR LOGICINPUTBLED = 1 THEN
        BTFSC PORTA,2,0
        BRA TRUE_24
        BTFSS PORTA,3,0
        BRA FALSE_14
TRUE_24
?I000070_F000_000161_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
        BRA ENDIF_11
FALSE_14
?I000071_F000_000163_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
ENDIF_11
?I000072_F000_000165_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000073_F000_000166_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000074_F000_000167_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000075_F000_000168_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000076_F000_000169_P000001 ; L#MK NORGATELED = 1
        BSF LATE,0,0
?I000077_F000_000170_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000078_F000_000171_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_13
?I000079_F000_000172_P000001 ; L#MK CASE 5
        MOVLW 5
        CPFSEQ M2_U08
        BRA FALSE_15
?I000080_F000_000173_P000001 ; L#MK IF LOGICINPUTALED = 1 AND LOGICINPUTBLED = 1 THEN
        BTFSS PORTA,2,0
        BRA FALSE_16
        BTFSS PORTA,3,0
        BRA FALSE_16
?I000081_F000_000174_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
        BRA ENDIF_12
FALSE_16
?I000082_F000_000176_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
ENDIF_12
?I000083_F000_000178_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000084_F000_000179_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000085_F000_000180_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000086_F000_000181_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000087_F000_000182_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000088_F000_000183_P000001 ; L#MK NANDGATELED = 1
        BSF LATE,1,0
?I000089_F000_000184_P000001 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
        BRA ENDIF_6
FALSE_15
?I000090_F000_000185_P000001 ; L#MK CASE 6
        MOVLW 6
        CPFSEQ M2_U08
        BRA ENDIF_6
?I000091_F000_000186_P000001 ; L#MK IF (LOGICINPUTALED = 0 AND LOGICINPUTBLED = 1) OR (LOGICINPU...
        BTFSC PORTA,2,0
        BRA LABEL_25
        BTFSC PORTA,3,0
        BRA TRUE_30
LABEL_25
        BTFSS PORTA,2,0
        BRA FALSE_17
        BTFSC PORTA,3,0
        BRA FALSE_17
TRUE_30
?I000092_F000_000187_P000001 ; L#MK LOGICGATESXLED = 0
        BCF LATC,0,0
        BRA ENDIF_13
FALSE_17
?I000093_F000_000189_P000001 ; L#MK LOGICGATESXLED = 1
        BSF LATC,0,0
ENDIF_13
?I000094_F000_000191_P000001 ; L#MK NOTGATELED = 0
        BCF LATA,4,0
?I000095_F000_000192_P000001 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000096_F000_000193_P000001 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000097_F000_000194_P000001 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000098_F000_000195_P000001 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000099_F000_000196_P000001 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000100_F000_000197_P000001 ; L#MK XNORGATELED = 1
        BSF LATE,2,0
ENDIF_6
?I000101_F000_000199_P000001 ; L#MK END SUB
        RETURN 0
PROC_DOFLIPFLOPS_0
?I000102_F000_000203_P000002 ; L#MK IF FLIPFLOPSELECT = 1 AND FLIPFLOPSELECTPRESSED = FALSE THEN
        BTFSS PORTB,7,0
        BRA FALSE_18
        BTFSC M0_U01,6,0
        BRA FALSE_18
?I000103_F000_000204_P000002 ; L#MK FLIPFLOPSELECTPRESSED = TRUE
        BSF M0_U01,6,0
?I000104_F000_000205_P000002 ; L#MK INC(WHICHFLIPFLOP)
        INCF M3_U08,1,0
?I000105_F000_000206_P000002 ; L#MK FLIPFLOPSJTDLED = 0
        BCF LATC,1,0
?I000106_F000_000207_P000002 ; L#MK FLIPFLOPRKLED = 0
        BCF LATC,3,0
?I000107_F000_000208_P000002 ; L#MK IF WHICHFLIPFLOP > 3 THEN
        MOVLW 3
        CPFSGT M3_U08
        BRA ENDIF_15
?I000108_F000_000209_P000002 ; L#MK WHICHFLIPFLOP = 0
        CLRF M3_U08,0
ENDIF_15
        BRA ENDIF_14
FALSE_18
?I000109_F000_000211_P000002 ; L#MK ELSEIF FLIPFLOPSELECT = 0 THEN
        BTFSS PORTB,7,0
?I000110_F000_000212_P000002 ; L#MK FLIPFLOPSELECTPRESSED = FALSE
        BCF M0_U01,6,0
ENDIF_14
?I000111_F000_000215_P000002 ; L#MK IF FLIPFLOPSJTD = 1 AND FLIPFLOPSJTDPRESSED = FALSE THEN
        BTFSS PORTB,4,0
        BRA FALSE_19
        BTFSC M0_U01,3,0
        BRA FALSE_19
?I000112_F000_000216_P000002 ; L#MK FLIPFLOPSJTDPRESSED = TRUE
        BSF M0_U01,3,0
?I000113_F000_000217_P000002 ; L#MK IF FLIPFLOPSJTDLED = 0 THEN
        BTFSC PORTC,1,0
        BRA FALSE_20
?I000114_F000_000218_P000002 ; L#MK FLIPFLOPSJTDLED = 1
        BSF LATC,1,0
        BRA ENDIF_17
FALSE_20
?I000115_F000_000220_P000002 ; L#MK FLIPFLOPSJTDLED = 0
        BCF LATC,1,0
ENDIF_17
        BRA ENDIF_16
FALSE_19
?I000116_F000_000222_P000002 ; L#MK ELSEIF FLIPFLOPSJTD = 0 THEN
        BTFSS PORTB,4,0
?I000117_F000_000223_P000002 ; L#MK FLIPFLOPSJTDPRESSED = FALSE
        BCF M0_U01,3,0
ENDIF_16
?I000118_F000_000226_P000002 ; L#MK IF FLIPFLOPRK = 1 AND FLIPFLOPRKPRESSED = FALSE AND WHICHFLI...
        BTFSS PORTB,6,0
        BRA FALSE_21
        BTFSC M0_U01,5,0
        BRA FALSE_21
        MOVLW 2
        CPFSLT M3_U08
        BRA FALSE_21
?I000119_F000_000227_P000002 ; L#MK FLIPFLOPRKPRESSED = TRUE
        BSF M0_U01,5,0
?I000120_F000_000228_P000002 ; L#MK IF FLIPFLOPRKLED = 0 THEN
        BTFSC PORTC,3,0
        BRA FALSE_22
?I000121_F000_000229_P000002 ; L#MK FLIPFLOPRKLED = 1
        BSF LATC,3,0
        BRA ENDIF_19
FALSE_22
?I000122_F000_000231_P000002 ; L#MK FLIPFLOPRKLED = 0
        BCF LATC,3,0
ENDIF_19
        BRA ENDIF_18
FALSE_21
?I000123_F000_000233_P000002 ; L#MK ELSEIF FLIPFLOPRK = 0 THEN
        BTFSS PORTB,6,0
?I000124_F000_000234_P000002 ; L#MK FLIPFLOPRKPRESSED = FALSE
        BCF M0_U01,5,0
ENDIF_18
?I000125_F000_000237_P000002 ; L#MK IF FLIPFLOPCLOCK = 1 AND FLIPFLOPCLOCKPRESSED = FALSE THEN
        BTFSS PORTB,5,0
        BRA FALSE_23
        BTFSC M0_U01,4,0
        BRA FALSE_23
?I000126_F000_000238_P000002 ; L#MK FLIPFLOPCLOCKPRESSED = TRUE
        BSF M0_U01,4,0
?I000127_F000_000239_P000002 ; L#MK FLIPFLOPCLOCKLED = 1
        BSF LATC,2,0
?I000128_F000_000240_P000002 ; L#MK CLOCKEDGE = TRUE
        BSF M1_U01,1,0
        BRA ENDIF_20
FALSE_23
?I000129_F000_000241_P000002 ; L#MK ELSEIF FLIPFLOPCLOCK = 0 THEN
        BTFSC PORTB,5,0
        BRA ENDIF_20
?I000130_F000_000242_P000002 ; L#MK FLIPFLOPCLOCKPRESSED = FALSE
        BCF M0_U01,4,0
?I000131_F000_000243_P000002 ; L#MK FLIPFLOPCLOCKLED = 0
        BCF LATC,2,0
ENDIF_20
?I000132_F000_000246_P000002 ; L#MK SELECT WHICHFLIPFLOP
?I000133_F000_000247_P000002 ; L#MK CASE 0
        TSTFSZ M3_U08,0
        BRA FALSE_24
?I000134_F000_000248_P000002 ; L#MK IF CLOCKEDGE = TRUE THEN
        BTFSS M1_U01,1,0
        BRA ENDIF_22
?I000135_F000_000249_P000002 ; L#MK CLOCKEDGE = FALSE   ' RESET THE CLOCK EDGE
        BCF M1_U01,1,0
?I000136_F000_000250_P000002 ; L#MK IF FLIPFLOPSJTDLED = 0 AND FLIPFLOPRKLED = 0 THEN
        BTFSC PORTC,1,0
        BRA FALSE_25
        BTFSS PORTC,3,0
        BRA ENDIF_23
FALSE_25
?I000137_F000_000252_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 0 AND FLIPFLOPRKLED = 1 THEN
        BTFSC PORTC,1,0
        BRA FALSE_26
        BTFSS PORTC,3,0
        BRA FALSE_26
?I000138_F000_000253_P000002 ; L#MK FLIPFLOPQLED = 0
        BCF LATD,2,0
?I000139_F000_000254_P000002 ; L#MK FLIPFLOPNOTQLED = 1
        BSF LATD,3,0
        BRA ENDIF_23
FALSE_26
?I000140_F000_000255_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 1 AND FLIPFLOPRKLED = 0 THEN
        BTFSS PORTC,1,0
        BRA FALSE_27
        BTFSC PORTC,3,0
        BRA FALSE_27
?I000141_F000_000256_P000002 ; L#MK FLIPFLOPQLED = 1
        BSF LATD,2,0
?I000142_F000_000257_P000002 ; L#MK FLIPFLOPNOTQLED = 0
        BCF LATD,3,0
        BRA ENDIF_23
FALSE_27
?I000143_F000_000258_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 1 AND FLIPFLOPRKLED = 1 THEN
        BTFSS PORTC,1,0
        BRA ENDIF_23
        BTFSS PORTC,3,0
        BRA ENDIF_23
?I000144_F000_000259_P000002 ; L#MK FLIPFLOPQLED = 0
        BCF LATD,2,0
?I000145_F000_000260_P000002 ; L#MK FLIPFLOPNOTQLED = 0
        BCF LATD,3,0
ENDIF_23
ENDIF_22
?I000146_F000_000263_P000002 ; L#MK SRFLIPFLOPLED = 1
        BSF LATC,4,0
?I000147_F000_000264_P000002 ; L#MK JKFLIPFLOPLED = 0
        BCF LATC,5,0
?I000148_F000_000265_P000002 ; L#MK TFLIPFLOPLED = 0
        BCF LATD,0,0
?I000149_F000_000266_P000002 ; L#MK DFLIPFLOPLED = 0
        BCF LATD,1,0
        BRA ENDIF_21
FALSE_24
?I000150_F000_000267_P000002 ; L#MK CASE 1
        DECFSZ M3_U08,0,0
        BRA FALSE_28
?I000151_F000_000268_P000002 ; L#MK IF CLOCKEDGE = TRUE THEN
        BTFSS M1_U01,1,0
        BRA ENDIF_24
?I000152_F000_000269_P000002 ; L#MK CLOCKEDGE = FALSE   ' RESET THE CLOCK EDGE
        BCF M1_U01,1,0
?I000153_F000_000270_P000002 ; L#MK IF FLIPFLOPSJTDLED = 0 AND FLIPFLOPRKLED = 0 THEN
        BTFSC PORTC,1,0
        BRA FALSE_29
        BTFSS PORTC,3,0
        BRA ENDIF_25
FALSE_29
?I000154_F000_000272_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 0 AND FLIPFLOPRKLED = 1 THEN
        BTFSC PORTC,1,0
        BRA FALSE_30
        BTFSS PORTC,3,0
        BRA FALSE_30
?I000155_F000_000273_P000002 ; L#MK FLIPFLOPQLED = 0
        BCF LATD,2,0
?I000156_F000_000274_P000002 ; L#MK FLIPFLOPNOTQLED = 1
        BSF LATD,3,0
        BRA ENDIF_25
FALSE_30
?I000157_F000_000275_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 1 AND FLIPFLOPRKLED = 0 THEN
        BTFSS PORTC,1,0
        BRA FALSE_31
        BTFSC PORTC,3,0
        BRA FALSE_31
?I000158_F000_000276_P000002 ; L#MK FLIPFLOPQLED = 1
        BSF LATD,2,0
?I000159_F000_000277_P000002 ; L#MK FLIPFLOPNOTQLED = 0
        BCF LATD,3,0
        BRA ENDIF_25
FALSE_31
?I000160_F000_000278_P000002 ; L#MK ELSEIF FLIPFLOPSJTDLED = 1 AND FLIPFLOPRKLED = 1 THEN
        BTFSS PORTC,1,0
        BRA ENDIF_25
        BTFSS PORTC,3,0
        BRA ENDIF_25
?I000161_F000_000279_P000002 ; L#MK TOGGLE(FLIPFLOPQLED)
        BTG LATD,2
        BCF TRISD,2,0
?I000162_F000_000280_P000002 ; L#MK TOGGLE(FLIPFLOPNOTQLED)
        BTG LATD,3
        BCF TRISD,3,0
ENDIF_25
ENDIF_24
?I000163_F000_000283_P000002 ; L#MK SRFLIPFLOPLED = 0
        BCF LATC,4,0
?I000164_F000_000284_P000002 ; L#MK JKFLIPFLOPLED = 1
        BSF LATC,5,0
?I000165_F000_000285_P000002 ; L#MK TFLIPFLOPLED = 0
        BCF LATD,0,0
?I000166_F000_000286_P000002 ; L#MK DFLIPFLOPLED = 0
        BCF LATD,1,0
        BRA ENDIF_21
FALSE_28
?I000167_F000_000287_P000002 ; L#MK CASE 2
        MOVLW 2
        CPFSEQ M3_U08
        BRA FALSE_32
?I000168_F000_000288_P000002 ; L#MK IF CLOCKEDGE = TRUE THEN
        BTFSS M1_U01,1,0
        BRA ENDIF_26
?I000169_F000_000289_P000002 ; L#MK CLOCKEDGE = FALSE   ' RESET THE CLOCK EDGE
        BCF M1_U01,1,0
?I000170_F000_000290_P000002 ; L#MK IF FLIPFLOPSJTDLED = 0 THEN
        BTFSS PORTC,1,0
        BRA ENDIF_27
FALSE_33
?I000171_F000_000293_P000002 ; L#MK TOGGLE(FLIPFLOPQLED)
        BTG LATD,2
        BCF TRISD,2,0
?I000172_F000_000294_P000002 ; L#MK TOGGLE(FLIPFLOPNOTQLED)
        BTG LATD,3
        BCF TRISD,3,0
ENDIF_27
ENDIF_26
?I000173_F000_000297_P000002 ; L#MK SRFLIPFLOPLED = 0
        BCF LATC,4,0
?I000174_F000_000298_P000002 ; L#MK JKFLIPFLOPLED = 0
        BCF LATC,5,0
?I000175_F000_000299_P000002 ; L#MK TFLIPFLOPLED = 1
        BSF LATD,0,0
?I000176_F000_000300_P000002 ; L#MK DFLIPFLOPLED = 0
        BCF LATD,1,0
        BRA ENDIF_21
FALSE_32
?I000177_F000_000301_P000002 ; L#MK CASE 3
        MOVLW 3
        CPFSEQ M3_U08
        BRA ENDIF_21
?I000178_F000_000302_P000002 ; L#MK IF CLOCKEDGE = TRUE THEN
        BTFSS M1_U01,1,0
        BRA ENDIF_28
?I000179_F000_000303_P000002 ; L#MK CLOCKEDGE = FALSE   ' RESET THE CLOCK EDGE
        BCF M1_U01,1,0
?I000180_F000_000304_P000002 ; L#MK FLIPFLOPQLED = FLIPFLOPSJTDLED
        BTFSC PORTC,1,0
        BSF LATD,2,0
        BTFSS PORTC,1,0
        BCF LATD,2,0
?I000181_F000_000305_P000002 ; L#MK FLIPFLOPNOTQLED = FLIPFLOPSJTDLED XOR %1
        CLRF WREG,0
        BTFSC PORTC,1,0
        MOVLW 1
        MOVWF F0_U08,0
        MOVF F0_U08,0,0
        XORLW 1
        BSF LATD,3,0
        BTFSS WREG,0,0
        BCF LATD,3,0
ENDIF_28
?I000182_F000_000307_P000002 ; L#MK SRFLIPFLOPLED = 0
        BCF LATC,4,0
?I000183_F000_000308_P000002 ; L#MK JKFLIPFLOPLED = 0
        BCF LATC,5,0
?I000184_F000_000309_P000002 ; L#MK TFLIPFLOPLED = 0
        BCF LATD,0,0
?I000185_F000_000310_P000002 ; L#MK DFLIPFLOPLED = 1
        BSF LATD,1,0
ENDIF_21
?I000186_F000_000312_P000002 ; L#MK END SUB
        RETURN 0
PROC_DOCOUNTER_0
?I000187_F000_000316_P000003 ; L#MK IF COUNTERUP = 1 AND COUNTERUPPRESSED = FALSE THEN
        BTFSS PORTA,0,0
        BRA FALSE_34
        BTFSC M0_U01,7,0
        BRA FALSE_34
?I000188_F000_000317_P000003 ; L#MK COUNTERUPPRESSED = TRUE
        BSF M0_U01,7,0
?I000189_F000_000318_P000003 ; L#MK INC(COUNTERCOUNT)
        INCF M4_U08,1,0
?I000190_F000_000319_P000003 ; L#MK IF COUNTERCOUNT > 15 THEN
        MOVLW 15
        CPFSGT M4_U08
        BRA ENDIF_30
?I000191_F000_000320_P000003 ; L#MK COUNTERCOUNT = 0
        CLRF M4_U08,0
ENDIF_30
        BRA ENDIF_29
FALSE_34
?I000192_F000_000322_P000003 ; L#MK ELSEIF COUNTERUP = 0 THEN
        BTFSS PORTA,0,0
?I000193_F000_000323_P000003 ; L#MK COUNTERUPPRESSED = FALSE
        BCF M0_U01,7,0
ENDIF_29
?I000194_F000_000325_P000003 ; L#MK IF COUNTERDOWN = 1 AND COUNTERDOWNPRESSED = FALSE THEN
        BTFSS PORTA,1,0
        BRA FALSE_35
        BTFSC M1_U01,0,0
        BRA FALSE_35
?I000195_F000_000326_P000003 ; L#MK COUNTERDOWNPRESSED = TRUE
        BSF M1_U01,0,0
?I000196_F000_000327_P000003 ; L#MK DEC(COUNTERCOUNT)
        DECF M4_U08,1,0
?I000197_F000_000328_P000003 ; L#MK IF COUNTERCOUNT = 255 THEN
        INCFSZ M4_U08,0,0
        BRA ENDIF_32
?I000198_F000_000329_P000003 ; L#MK COUNTERCOUNT = 15
        MOVLW 15
        MOVWF M4_U08,0
ENDIF_32
        BRA ENDIF_31
FALSE_35
?I000199_F000_000331_P000003 ; L#MK ELSEIF COUNTERDOWN = 0 THEN
        BTFSS PORTA,1,0
?I000200_F000_000332_P000003 ; L#MK COUNTERDOWNPRESSED = FALSE
        BCF M1_U01,0,0
ENDIF_31
?I000201_F000_000335_P000003 ; L#MK COUNTER8LED = COUNTERCOUNT.BITS(3)
        BTFSC M4_U01,3,0
        BSF LATD,4,0
        BTFSS M4_U01,3,0
        BCF LATD,4,0
?I000202_F000_000336_P000003 ; L#MK COUNTER4LED = COUNTERCOUNT.BITS(2)
        BTFSC M4_U01,2,0
        BSF LATD,5,0
        BTFSS M4_U01,2,0
        BCF LATD,5,0
?I000203_F000_000337_P000003 ; L#MK COUNTER2LED = COUNTERCOUNT.BITS(1)
        BTFSC M4_U01,1,0
        BSF LATD,6,0
        BTFSS M4_U01,1,0
        BCF LATD,6,0
?I000204_F000_000338_P000003 ; L#MK COUNTER1LED = COUNTERCOUNT.BITS(0)
        BTFSC M4_U01,0,0
        BSF LATD,7,0
        BTFSS M4_U01,0,0
        BCF LATD,7,0
?I000205_F000_000339_P000003 ; L#MK END SUB
        RETURN 0
MAIN
?I000206_F000_000344_M000000 ; L#MK OSCCON = %01100000          ' DEVICE ENTERS SLEEP ON IDLE, 8...
        MOVLW 96
        MOVWF OSCCON,0
?I000207_F000_000345_M000000 ; L#MK OSCTUNE = %00000000         ' INTERNAL OSCILLATOR LOW FREQ C...
        CLRF OSCTUNE,0
?I000208_F000_000348_M000000 ; L#MK ANSEL = %00000000          ' DISABLE ALL ANALOG INPUTS (MAKE...
        CLRF ANSEL,0
?I000209_F000_000349_M000000 ; L#MK ANSELH = %00000000         ' DISABLE ALL ANALOG INPUTS (MAKE...
        CLRF ANSELH,0
?I000210_F000_000352_M000000 ; L#MK TRISA = %00000011
        MOVLW 3
        MOVWF TRISA,0
?I000211_F000_000353_M000000 ; L#MK TRISB = %11111110
        MOVLW 254
        MOVWF TRISB,0
?I000212_F000_000354_M000000 ; L#MK TRISC = %00000000
        CLRF TRISC,0
?I000213_F000_000355_M000000 ; L#MK TRISD = %00000000
        CLRF TRISD,0
?I000214_F000_000356_M000000 ; L#MK TRISE = %00000000
        CLRF TRISE,0
?I000215_F000_000359_M000000 ; L#MK WHICHLOGICGATE = 0
        CLRF M2_U08,0
?I000216_F000_000360_M000000 ; L#MK WHICHFLIPFLOP = 0
        CLRF M3_U08,0
?I000217_F000_000361_M000000 ; L#MK COUNTERCOUNT = 0
        CLRF M4_U08,0
?I000218_F000_000362_M000000 ; L#MK LOGICINPUTAPRESSED = FALSE
        BCF M0_U01,0,0
?I000219_F000_000363_M000000 ; L#MK LOGICINPUTBPRESSED = FALSE
        BCF M0_U01,1,0
?I000220_F000_000364_M000000 ; L#MK LOGICSELECTPRESSED = FALSE
        BCF M0_U01,2,0
?I000221_F000_000365_M000000 ; L#MK FLIPFLOPSJTDPRESSED = FALSE
        BCF M0_U01,3,0
?I000222_F000_000366_M000000 ; L#MK FLIPFLOPCLOCKPRESSED = FALSE
        BCF M0_U01,4,0
?I000223_F000_000367_M000000 ; L#MK FLIPFLOPRKPRESSED = FALSE
        BCF M0_U01,5,0
?I000224_F000_000368_M000000 ; L#MK FLIPFLOPSELECTPRESSED = FALSE
        BCF M0_U01,6,0
?I000225_F000_000369_M000000 ; L#MK COUNTERUPPRESSED = FALSE
        BCF M0_U01,7,0
?I000226_F000_000370_M000000 ; L#MK COUNTERDOWNPRESSED = FALSE
        BCF M1_U01,0,0
?I000227_F000_000373_M000000 ; L#MK LOGICINPUTALED = 0
        BCF LATA,2,0
?I000228_F000_000374_M000000 ; L#MK LOGICINPUTBLED = 0
        BCF LATA,3,0
?I000229_F000_000375_M000000 ; L#MK NOTGATELED = 1
        BSF LATA,4,0
?I000230_F000_000376_M000000 ; L#MK ORGATELED = 0
        BCF LATA,5,0
?I000231_F000_000377_M000000 ; L#MK ANDGATELED = 0
        BCF LATA,6,0
?I000232_F000_000378_M000000 ; L#MK XORGATELED = 0
        BCF LATA,7,0
?I000233_F000_000379_M000000 ; L#MK NORGATELED = 0
        BCF LATE,0,0
?I000234_F000_000380_M000000 ; L#MK NANDGATELED = 0
        BCF LATE,1,0
?I000235_F000_000381_M000000 ; L#MK XNORGATELED = 0
        BCF LATE,2,0
?I000236_F000_000382_M000000 ; L#MK FLIPFLOPSJTDLED = 0
        BCF LATC,1,0
?I000237_F000_000383_M000000 ; L#MK FLIPFLOPCLOCKLED = 0
        BCF LATC,2,0
?I000238_F000_000384_M000000 ; L#MK FLIPFLOPRKLED = 0
        BCF LATC,3,0
?I000239_F000_000385_M000000 ; L#MK SRFLIPFLOPLED = 1
        BSF LATC,4,0
?I000240_F000_000386_M000000 ; L#MK JKFLIPFLOPLED = 0
        BCF LATC,5,0
?I000241_F000_000387_M000000 ; L#MK TFLIPFLOPLED = 0
        BCF LATD,0,0
?I000242_F000_000388_M000000 ; L#MK DFLIPFLOPLED = 0
        BCF LATD,1,0
?I000243_F000_000389_M000000 ; L#MK FLIPFLOPQLED = 0
        BCF LATD,2,0
?I000244_F000_000390_M000000 ; L#MK FLIPFLOPNOTQLED = 1
        BSF LATD,3,0
?I000245_F000_000391_M000000 ; L#MK COUNTER8LED = 0
        BCF LATD,4,0
?I000246_F000_000392_M000000 ; L#MK COUNTER4LED = 0
        BCF LATD,5,0
?I000247_F000_000393_M000000 ; L#MK COUNTER2LED = 0
        BCF LATD,6,0
?I000248_F000_000394_M000000 ; L#MK COUNTER1LED = 0
        BCF LATD,7,0
?I000249_F000_000395_M000000 ; L#MK CLOCKEDGE = FALSE
        BCF M1_U01,1,0
?I000250_F000_000398_M000000 ; L#MK WHILE TRUE()
WHILE_0
?I000251_F000_000399_M000000 ; L#MK DOLOGICGATES
        RCALL PROC_DOLOGICGATES_0
?I000252_F000_000400_M000000 ; L#MK DOFLIPFLOPS
        RCALL PROC_DOFLIPFLOPS_0
?I000253_F000_000401_M000000 ; L#MK DOCOUNTER
        RCALL PROC_DOCOUNTER_0
        BRA WHILE_0
?I000254_END; L#MK
SBGLB2
        SLEEP
        BRA SBGLB2
 CONFIG FOSC = INTIO67
 CONFIG FCMEN = OFF
 CONFIG IESO = OFF
 CONFIG PWRT = ON
 CONFIG BOREN = OFF
 CONFIG BORV = 27
 CONFIG WDTEN = OFF
 CONFIG WDTPS = 128
 CONFIG PBADEN = OFF
 CONFIG MCLRE = OFF
 CONFIG STVREN = ON
 CONFIG LVP = OFF
 CONFIG XINST = OFF
 CONFIG DEBUG = OFF
SB#ASMEND
        END
